classdef class_REVS_CVT_transmission 
	%class_REVS_AT_transmission
	%   Definition of class_REVS_AT_transmission class
	
	properties
		% Base Properties
        matrix_vintage = enum_matrix_vintage.present;

        name                = '';                           % Description of transmission
        
        rated_torque_Nm     = 0;                            % transmission rated input torque in Newton-meters
        
		gear                = class_REVS_gearbox;			% Gearbox Definition
		torque_converter    = class_REVS_torque_converter;	% Torque Converter Definition
		control             = class_REVS_CVT_control;       % AT Control Parameters
		thermal;                                            % Thermal Definintion
		pump_loss_Nm;                                       % Transmission Pump Loss - Dynamic Lookup
		
		gear_strategy;                                      % Gear selection strategy structure / class
		tcc_strategy;                                       % TCC lockup strategy structure / class
        
        cold_correction     = 0;                            % cold correction factor for UDDS bag1, used by MTE matrix
	end
	
	methods ( Static = true )		
		% Constructor
		
		function obj = class_REVS_CVT_transmission()
			
			obj.gear.type = enum_transmission_type.CVT;
			obj.gear.shift_duration_secs = 1.0;             % for CVT this controls the neutral engage duration, not normal operation
	
        end
    end
end

